﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography.X509Certificates;
using CryptoCMP.OCSP;

namespace testOCSP_cmp
{
    class Program
    {
        static void Main(string[] args)
        {
            // Выбираем проверяемый сертификат
            X509Store store = new X509Store("MY");
            X509Certificate2 cert = null;
            try
            {
                store.Open(OpenFlags.ReadOnly);
                X509Certificate2Collection certCollection = store.Certificates;
                X509Certificate2Collection signingCert = certCollection.Find(X509FindType.FindBySubjectName, "test", false);
                cert = signingCert[0];
            }
            finally
            {
                store.Close();
            }
            
            // формируем запрос
            OCSPRequest ocsp_req = new OCSPRequest("profile://test", cert.RawData);
            byte[] o_req = ocsp_req.GetEncoded();
            // отсылаем 
            CryptoCMP.Utils.SendRequest send = new CryptoCMP.Utils.SendRequest();
            int err = 0;
            byte[] resp2 = send.SendMessage(5, "127.0.0.1", "62265", o_req, ref err); 
             
            // парсим ответ
            OCSPResponce ocsp_resp = new OCSPResponce("profile://OCSP_TEST", resp2);
            bool res = ocsp_resp.verify;
            int reason = ocsp_resp.Reason;
            string rec_time = ocsp_resp.RefreshTime;
            X509Certificate2 sign_cert = ocsp_resp.SignerCert;
            int status = ocsp_resp.Status;
            

        }
    }
}
